<?php
namespace DF\HUB_V2;

/**
 * Gutenberg.
 */
class Gutenberg
{
    public static $categoryAdded = false;

    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * Add a custom mrkwp block to the gutenberg blocks
     */
    public function add_mrkwp_block_category()
    {
        add_filter(
            'block_categories',
            function ($categories, $post) {
                if (\DF\HUB_V2\Gutenberg::$categoryAdded) {
                    return $categories;
                }
                \DF\HUB_V2\Gutenberg::$categoryAdded = true;
                return array_merge(
                    $categories,
                    [
                        [
                            'slug'  => 'mrkwp-blocks',
                            'title' => __('MRKWP Blocks', 'mrkwp-blocks'),
                        ],
                    ]
                );
            },
            10,
            2
        );

    }
}